#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#pragma warning (disable: 4800 4100)
#ifndef WIN32
#define stricmp strcasecmp
#define __min(a,b) (((a) < (b)) ? (a) : (b))
#define _strdup strdup
#endif
typedef unsigned char GameObject;
typedef unsigned char ScriptSaver;
typedef unsigned char ScriptLoader;
class ScriptFactory;
class ScriptClass;
typedef void (*rdf) (ScriptClass *scr);
typedef enum {
	ACTION_COMPLETE_ATTACK_OUT_OF_RANGE = 1,
	ACTION_COMPLETE_MOVE_NO_PROGRESS_MADE = 2,
	ACTION_COMPLETE_PATH_BAD_DEST = 3,
	ACTION_COMPLETE_PATH_BAD_START = 4,
	ACTION_COMPLETE_LOW_PRIORITY = 5,
	ACTION_COMPLETE_NORMAL = 6
} ActionCompleteReason;
struct SeralizeInfoStr {
	void *data;
	int size;
	int number;
	SeralizeInfoStr *next;
};
struct Vector3 {
	float X;
	float Y;
	float Z;
};
struct CombatSound {
	Vector3 position; //this is passed from the position parameter of Create_Logical_Sound
	int sound; //this is passed from the sound parameter of Create_Logical_Sound
	GameObject *obj; //this is passed from the obj parameter of Create_Logical_Sound
};
class GameObjObserverClass {
protected:
	int ID;
public:
	virtual ~GameObjObserverClass();
	virtual char *Get_Name() = 0;
	virtual void Attatch(GameObject * newobj) = 0;
	virtual void Detatch(GameObject *obj) = 0;
	virtual void Created(GameObject *obj) = 0;
	virtual void Destroyed(GameObject *obj) = 0;
	virtual void Killed(GameObject *obj,GameObject * shooter) = 0;
	virtual void Damaged(GameObject *obj,GameObject * damager,float damage) = 0;
	virtual void Custom(GameObject *obj,int message,int param,GameObject * sender) = 0;
	virtual void Sound_Heard(GameObject *obj,const CombatSound & sound) = 0;
	virtual void Enemy_Seen(GameObject *obj,GameObject * seen) = 0;
	virtual void Action_Complete(GameObject *obj,int action,ActionCompleteReason reason) = 0;
	virtual void Timer_Expired(GameObject *obj,int number) = 0;
	virtual void Animation_Complete(GameObject *obj,const char *anim) = 0;
	virtual void Poked(GameObject *obj,GameObject * poker) = 0;
	virtual void Entered(GameObject *obj,GameObject * enter) = 0;
	virtual void Exited(GameObject *obj,GameObject * exit) = 0;
	int GetID()
	{
		return ID;
	}
};
class ScriptClass : public GameObjObserverClass {
};
class ScriptImpClass : public ScriptClass {
private:
	GameObject *Attatched;
	int mArgC;
	char **mArgV;
	ScriptFactory *Factory;
	SeralizeInfoStr *seralizeinfo;
	static rdf RequestDestroyScript;
public:
	static void Set_Request_Destroy_Func(rdf Func);
	void SetFactory(ScriptFactory *ptr)
	{
		Factory = ptr;
	}
	ScriptImpClass();
	void Destroy_Script();
	int CheckPlayerType(GameObject *obj,int type);
	void Auto_Save_Variable(int number,int size,void *var);
	~ScriptImpClass();
	char *Get_Name();
	void Attatch(GameObject * newobj);
	void Detatch(GameObject *obj);
	void Created(GameObject *obj); //triggers on script creation
	void Destroyed(GameObject *obj); //triggers on script shutdown
	void Killed(GameObject *obj,GameObject * shooter); //triggers when the object script is attatched to dies
	void Damaged(GameObject *obj,GameObject * damager,float damage); //triggers when the object script is attatched to is damaged. The damager is always the gunner, not the vechicle.
	void Custom(GameObject *obj,int message,int param,GameObject * sender); //triggers when the script is sent a custom (aka message). Several system events are triggered by Customs as well, see the #defines below
	void Sound_Heard(GameObject *obj,const CombatSound & sound); //something to do with sound, I think it triggers when the object the script is attatched to hears a sound)
	void Enemy_Seen(GameObject *obj,GameObject * seen); //triggers when the object script is attatched to spots an enemy
	void Action_Complete(GameObject *obj,int action,ActionCompleteReason reason); //triggers when an action on the object the script is attatched to completes
	void Timer_Expired(GameObject *obj,int number); //triggers when a timer goes off
	void Animation_Complete(GameObject *obj,const char *anim); //triggers when an animation on the object the script is attatched to completes
	void Poked(GameObject *obj,GameObject * poker); //triggers when the object that this scripts is attatched to is poked (i.e. player pushes the action key while this object is active), this doesnt work in MP
	void Entered(GameObject *obj,GameObject * enter); //triggers when the zone this script is attatched to is entered
	void Exited(GameObject *obj,GameObject * exit); //triggers when the zone this script is attatched to is exited
	virtual GameObject *Owner();
	virtual GameObject **Get_Owner_Ptr();
	virtual void Set_Parameters_String(const char *params);
	virtual void Get_Parameters_String(char *params,unsigned int size);
	virtual void Save(ScriptSaver &saver);
	virtual void Load(ScriptLoader &loader);
	virtual void Save_Data(ScriptSaver &saver);
	virtual void Load_Data(ScriptLoader &loader);
	virtual void Register_Auto_Save_Variables();
	void Clear_Parameters();
	const char* Get_Parameter(const char* v);
	const char* Get_Parameter(int v);
	int Get_Int_Parameter(const char* v);
	float Get_Float_Parameter(const char *v);
	Vector3 Get_Vector3_Parameter(int v);
	Vector3 Get_Vector3_Parameter(const char* v);
	int Get_Parameter_Index(const char* v);
	int Get_Parameter_Count();
	int Get_Int_Parameter(int v);
	float Get_Float_Parameter(int v);
	void Set_Parameter(int pos,char const *v);
};
class ActionParamsStruct {
public:
	unsigned long Action_Priority;
	unsigned long Action_ID;
	unsigned int ID;
	Vector3 varB8;
	GameObject * varAC;
	float varA8;
	Vector3 Move_Destination;
	GameObject * Move_Target;
	Vector3 var94;
	float Move_Speed;
	float Move_Arrive_Distance;
	bool Move_Backwards;
	bool Move_Following;
	bool Move_Crouch;
	bool Move_Pathfind;
	bool var7C;
	float Attack_Range;
	float Attack_Deviation;
	bool var70;
	GameObject * Attack_Target;
	bool Attack_Primary;
	bool Attack_Crouched;
	Vector3 Attack_Location;
	bool Hold_Action;
	bool var57;
	bool var56;
	bool var55;
	bool var54;
	bool var53;
	Vector3 Face_Location;
	float Face_Time;
	bool var40;
	unsigned long Move_Waypath_ID;
	unsigned long Move_Waypath_Start_ID;
	unsigned long Move_Waypath_End_ID;
	bool Move_Waypath_Splined;
	const char *Anim_Name;
	bool Anim_Loop;
	unsigned int var24;
	const char *var20;
	long var1C;
	Vector3 Dock_Location;
	Vector3 Dock_Entrance;
	ActionParamsStruct();
	void Set_Basic(ScriptClass *s,unsigned long priority,unsigned long ID,long var1C);
	void Set_Attack(GameObject * Target,float range,float deviation,bool primary);
	void Set_Attack_Hold(GameObject * Target,float range,float deviation,bool primary,bool Hold);
	void Set_Attack_Position(const Vector3 & position,float Range,float Deviation,bool Primary);
	void Set_Animation(const char *animname,bool loop);
	void Set_Face_Location(const Vector3 & facelocation,float Time);
	void Set_Dock(const Vector3 & docklocation,const Vector3 & dockentrance);
	void Set_Goto_Location(const Vector3 & position,float speed,float arrivedistance,bool crouch);
	void Set_Goto_Following(GameObject * Target,float speed,float arrivedistance,bool following);
	void Set_Goto_Crouch(GameObject * Target,float speed,float arrivedistance,bool crouch);
	void Set_Goto_Crouch_Following(GameObject * Target,float speed,float arrivedistance,bool crouch,bool following);
	void Set_Goto(GameObject * Target,float speed,float arrivedistance);
	void Set_Goto_Waypath_Start(unsigned long waypathID,unsigned long waypathstartID,unsigned long waypathendID,bool splined);
	void Set_Goto_Waypath(unsigned long waypathID,bool splined,bool v57,bool Hold);
	void Set_Goto_Waypath_ID(unsigned long waypathID);
	void Set_Move_Arrive_Distance(float distance);
	void Set_v54(bool v54);
};
extern float MoveArriveDistance;
inline ActionParamsStruct::ActionParamsStruct()
{
	Action_Priority = 0;
	Action_ID = 0;
	ID = 0;
	varB8.X = 0;
	varB8.Y = 0;
	varB8.Z = 0;
	varAC = 0;
	varA8 = 0;
	Move_Destination.X = 0;
	Move_Destination.Y = 0;
	Move_Destination.Z = 0;
	Move_Target = 0;
	var94.X = 0;
	var94.Y = 0;
	var94.Z = 0;
	Move_Speed = 1.0;
	Move_Arrive_Distance = MoveArriveDistance;
	Move_Backwards = false;
	Move_Following = false;
	Move_Crouch = false;
	Move_Pathfind = true;
	var7C = false;
	Attack_Range = 20;
	Attack_Deviation = 0;
	var70 = false;
	Attack_Target = 0;
	Attack_Primary = true;
	Attack_Crouched = false;
	Attack_Location.X = 0;
	Attack_Location.Y = 0;
	Attack_Location.Z = 0;
	Hold_Action = true;
	var57 = true;
	var56 = false;
	var55 = true;
	var54 = false;
	var53 = false;
	Face_Location.X = 0;
	Face_Location.Y = 0;
	Face_Location.Z = 0;
	Face_Time = 2.0;
	var40 = false;
	Move_Waypath_ID = 0;
	Move_Waypath_Start_ID = 0;
	Move_Waypath_End_ID = 0;
	Move_Waypath_Splined = false;
	Anim_Name = 0;
	Anim_Loop = false;
	var24 = 0;
	var20 = 0;
	var1C = -1;
	Dock_Location.X = 0;
	Dock_Location.Y = 0;
	Dock_Location.Z = 0;
	Dock_Entrance.X = 0;
	Dock_Entrance.Y = 0;
	Dock_Entrance.Z = 0;
}
void inline ActionParamsStruct::Set_v54(bool v54)
{
	var54 = v54;
}
void inline ActionParamsStruct::Set_Move_Arrive_Distance(float distance)
{
	Move_Arrive_Distance = distance;
}
void inline ActionParamsStruct::Set_Goto_Location(const Vector3 & position,float speed,float arrivedistance,bool crouch)
{
	Move_Destination.X = position.X;
	Move_Destination.Y = position.Y;
	Move_Destination.Z = position.Z;
	Move_Speed = speed;
	Move_Arrive_Distance = arrivedistance;
	Move_Crouch = crouch;
}
void inline ActionParamsStruct::Set_Goto_Following(GameObject * Target,float speed,float arrivedistance,bool following)
{
	Move_Target = Target;
	Move_Speed = speed;
	Move_Arrive_Distance = arrivedistance;
	Move_Following = following;
}
void inline ActionParamsStruct::Set_Goto_Crouch(GameObject * Target,float speed,float arrivedistance,bool crouch)
{
	Move_Target = Target;
	Move_Speed = speed;
	Move_Arrive_Distance = arrivedistance;
	Move_Crouch = crouch;
}
void inline ActionParamsStruct::Set_Goto_Crouch_Following(GameObject * Target,float speed,float arrivedistance,bool crouch,bool following)
{
	Move_Target = Target;
	Move_Speed = speed;
	Move_Arrive_Distance = arrivedistance;
	Move_Crouch = crouch;
	Move_Following = following;
}
void inline ActionParamsStruct::Set_Goto(GameObject * Target,float speed,float arrivedistance)
{
	Move_Target = Target;
	Move_Speed = speed;
	Move_Arrive_Distance = arrivedistance;
}
void inline ActionParamsStruct::Set_Goto_Waypath_Start(unsigned long waypathID,unsigned long waypathstartID,unsigned long waypathendID,bool splined)
{
	Move_Waypath_ID = waypathID;
	Move_Waypath_Start_ID = waypathstartID;
	Move_Waypath_End_ID = waypathendID;
	Move_Waypath_Splined = splined;
}
void inline ActionParamsStruct::Set_Goto_Waypath(unsigned long waypathID,bool splined,bool v57,bool Hold)
{
	Move_Waypath_ID = waypathID;
	Move_Waypath_Splined = splined;
	var57 = v57;
	Hold_Action = Hold;
}
void inline ActionParamsStruct::Set_Goto_Waypath_ID(unsigned long waypathID)
{
	Move_Waypath_ID = waypathID;
}
void inline ActionParamsStruct::Set_Dock(const Vector3 & docklocation,const Vector3 & dockentrance)
{
	Dock_Location.X = docklocation.X;
	Dock_Location.Y = docklocation.Y;
	Dock_Location.Z = docklocation.Z;
	Dock_Entrance.X = dockentrance.X;
	Dock_Entrance.Y = dockentrance.Y;
	Dock_Entrance.Z = dockentrance.Z;
}
void inline ActionParamsStruct::Set_Face_Location(const Vector3 & facelocation,float Time)
{
	Face_Location.X = facelocation.X;
	Face_Location.Y = facelocation.Y;
	Face_Location.Z = facelocation.Z;
	Face_Time = Time;
}
void inline ActionParamsStruct::Set_Animation(const char *animname,bool loop)
{
	Anim_Name = animname;
	Anim_Loop = loop;
}
void inline ActionParamsStruct::Set_Basic(ScriptClass *s,unsigned long priority,unsigned long ID,long v1C)
{
	ID = s->GetID();
	Action_Priority = priority;
	Action_ID = ID;
	var1C = v1C;
}
void inline ActionParamsStruct::Set_Attack(GameObject * Target,float Range,float Deviation,bool Primary)
{
	Attack_Target = Target;
	Attack_Range = Range;
	Attack_Deviation = Deviation;
	Attack_Primary = Primary;
}
void inline ActionParamsStruct::Set_Attack_Hold(GameObject * Target,float Range,float Deviation,bool Primary,bool Hold)
{
	Attack_Target = Target;
	Attack_Range = Range;
	Attack_Deviation = Deviation;
	Attack_Primary = Primary;
	Hold_Action = Hold;
}
void inline ActionParamsStruct::Set_Attack_Position(const Vector3 & position,float Range,float Deviation,bool Primary)
{
	Attack_Range = Range;
	Attack_Location.X = position.X;
	Attack_Location.Y = position.Y;
	Attack_Location.Z = position.Z;
	Attack_Deviation = Deviation;
	Attack_Primary = Primary;
}
#define CUSTOM_EVENT_SYSTEM_FIRST 1000000000 //this is what I believe is the marker that specifies the first system message
#define CUSTOM_EVENT_SOUND_ENDED 1000000001 //this one is sent when a sound finishes playing (if the sound was monitored with Monitor_Sound
#define CUSTOM_EVENT_TOGGLE_POWER 1000000002 //this one is sent on toggle power
#define CUSTOM_EVENT_ARRIVED_AT_DOCK 1000000003 //this one is sent when the thing gets to the dock
#define CUSTOM_EVENT_POWERUP 1000000025 //this one is sent to an item when its collected
#define CUSTOM_EVENT_DAMAGE 1000000026 //all I know is that this one has something to do with damage
#define CUSTOM_EVENT_HEAL 1000000027 //all I know is that this one has something to do with getting health back
#define CUSTOM_EVENT_VEHICLE_ENTER 1000000028 //this one gets sent to a vechicle when something enters it
#define CUSTOM_EVENT_VEHICLE_EXIT 1000000029 //this one gets sent to a vechicle when something exits it
#define CUSTOM_EVENT_ATTACK_ARRIVE 1000000030 //this one gets sent on something to do with arriving at attack location
#define CUSTOM_EVENT_AUDIENCE 1000000031 //this one gets sent on something to do with audience for a conversation
#define CUSTOM_EVENT_NEXT_REMARK 1000000032 //this one gets sent on something to do with say next remark
#define CUSTOM_EVENT_NEXT_REMARK2 1000000033 //this one also gets sent on something to do with say next remark but a different bit of code
#define CUSTOM_EVENT_JUMP_COMPLETE 1000000035 //this one gets sent when the jump is complete
class ScriptFactory {
private:
	ScriptFactory *next;
	char *name;
	char *params;
	int temp;
public:
	virtual ~ScriptFactory();
	virtual ScriptImpClass *Create() = 0;
	ScriptFactory(char *n,char *p);
	ScriptFactory *GetNext();
	void SetNext(ScriptFactory *ptr);
	char *GetName();
	char *GetParamDescription();
};
class ScriptRegistrar {
private:
	static ScriptFactory *mScriptFactories;
public:
	static void RegisterScript(ScriptFactory *ptr);
	static void UnregisterScript(ScriptFactory *ptr);
	static ScriptImpClass *CreateScript(const char *name);
	static ScriptFactory *GetScriptFactory(const char *name);
	static ScriptFactory *GetScriptFactory(int);
	static int Count();
};
template <class T> class ScriptRegistrant : public ScriptFactory {
	public:
	ScriptRegistrant(char *n,char *p) : ScriptFactory(n,p)
	{
	}
	ScriptImpClass *Create();
};
template <class T> ScriptImpClass *ScriptRegistrant<T>::Create()
	{
		ScriptImpClass *scr = new T;
		scr->SetFactory(this);
		scr->Register_Auto_Save_Variables();
		return scr;
	}
typedef void (*_Debug_Message) (const char * msg,...);
typedef void (*_Action_Reset) (GameObject *obj,float reset);
typedef void (*_Action_Goto) (GameObject *obj,const ActionParamsStruct & params);
typedef void (*_Action_Attack) (GameObject *obj,const ActionParamsStruct & params);
typedef void (*_Action_Play_Animation) (GameObject *obj,const ActionParamsStruct & params);
typedef void (*_Action_Enter_Exit) (GameObject *obj,const ActionParamsStruct & params);
typedef void (*_Action_Face_Location) (GameObject *obj,const ActionParamsStruct & params);
typedef void (*_Action_Dock) (GameObject *obj,const ActionParamsStruct & params);
typedef void (*_Action_Follow_Input) (GameObject *obj,const ActionParamsStruct & params);
typedef void (*_Modify_Action) (GameObject *obj,int actionid,const ActionParamsStruct & params,bool unk1,bool unk2);
typedef int (*_Get_Action_ID) (GameObject *obj);
typedef void (*_Get_Action_Params) (GameObject *obj,ActionParamsStruct & params);
typedef bool (*_Is_Performing_Pathfind_Action) (GameObject *obj);
typedef void (*_Set_Position) (GameObject *obj,const Vector3 & position);
typedef Vector3 (*_Get_Position) (GameObject *obj);
typedef Vector3 (*_Get_Bone_Position) (GameObject *obj,const char *bone);
typedef float (*_Get_Facing) (GameObject *obj);
typedef void (*_Set_Facing) (GameObject *obj,float facing);
typedef void (*_Disable_All_Collisions) (GameObject *obj);
typedef void (*_Disable_Physical_Collisions) (GameObject *obj);
typedef void (*_Enable_Collisions) (GameObject *obj);
typedef void (*_Destroy_Object) (GameObject *obj);
typedef GameObject *(*_Find_Object) (int id);
typedef GameObject *(*_Create_Object) (const char *preset,const Vector3 & Position);
typedef GameObject *(*_Create_Object_At_Bone) (GameObject *obj,const char *preset,const char *bone);
typedef int (*_Get_ID) (GameObject *obj);
typedef int (*_Get_Preset_ID) (GameObject *obj);
typedef const char *(*_Get_Preset_Name) (GameObject *obj);
typedef void (*_Attach_Script) (GameObject *obj,const char *scrname,const char *params);
typedef void (*_Add_To_Dirty_Cull_List) (GameObject *obj);
typedef void (*_Start_Timer) (GameObject *obj,ScriptClass *scr,float time,int number);
typedef void (*_Trigger_Weapon) (GameObject *obj,bool fire,const Vector3 &location,bool primary);
typedef void (*_Select_Weapon) (GameObject *obj,const char *weapon);
typedef void (*_Send_Custom_Event) (GameObject *sender,GameObject *reciever,int message,int param,float delay);
typedef void (*_Send_Damaged_Event) (GameObject *obj,GameObject *damager);
typedef float (*_Get_Random) (float min,float max);
typedef int (*_Get_Random_Int) (int min,int max);
typedef void (*_Find_Random_Simple_Object) (const char *obj);
typedef void (*_Set_Model) (GameObject *obj,const char *model);
typedef void (*_Set_Animation) (GameObject *obj,const char *animation,bool loop,const char *subobject,float firstframe,float lastframe,bool blended);
typedef void (*_Set_Animation_Frame) (GameObject *obj,const char *animation,int frame);
typedef int (*_Create_Sound) (const char *soundname,const Vector3 & position, GameObject *obj);
typedef int (*_Create_2D_Sound) (const char *soundname);
typedef int (*_Create_2D_WAV_Sound) (const char *soundname);
typedef int (*_Create_3D_WAV_Sound_At_Bone) (const char *soundname,GameObject *obj,const char *bonename);
typedef int (*_Create_3D_Sound_At_Bone) (const char *soundname,GameObject *obj,const char *bonename);
typedef int (*_Create_Logical_Sound) (GameObject *obj,int sound,const Vector3 & position,float unk);
typedef void (*_Start_Sound) (int soundnum);
typedef void (*_Stop_Sound) (int soundnum,bool unk);
typedef void (*_Monitor_Sound) (GameObject *obj,int sound);
typedef void (*_Set_Background_Music) (const char *music);
typedef void (*_Fade_Background_Music) (const char *music,int unk1,int unk2);
typedef void (*_Stop_Background_Music) ();
typedef float (*_Get_Health) (GameObject *obj);
typedef float (*_Get_Max_Health) (GameObject *obj);
typedef void (*_Set_Health) (GameObject *obj,float health);
typedef float (*_Get_Shield_Strength) (GameObject *obj);
typedef float (*_Get_Max_Shield_Strength) (GameObject *obj);
typedef void (*_Set_Shield_Strength) (GameObject *obj,float armour);
typedef void (*_Set_Shield_Type) (GameObject *obj,const char *type);
typedef int (*_Get_Player_Type) (GameObject *obj);
typedef void (*_Set_Player_Type) (GameObject *obj,int type);
typedef float (*_Get_Distance) (const Vector3 & pos1,const Vector3 & pos2);
typedef void (*_Set_Camera_Host) (GameObject *obj);
typedef void (*_Force_Camera_Look) (const Vector3 & look);
typedef GameObject *(*_Get_The_Star) ();
typedef GameObject *(*_Get_A_Star) (const Vector3 & pos);
typedef GameObject *(*_Find_Closest_Soldier) (const Vector3 & pos,float StartDistance,float EndDistance,bool unk);
typedef bool (*_Is_A_Star) (GameObject *obj);
typedef void (*_Control_Enable) (GameObject *obj,bool enable);
typedef const char *(*_Get_Damage_Bone_Name) ();
typedef float (*_Get_Damage_Bone_Direction) ();
typedef bool (*_Is_Object_Visible) (GameObject *obj,GameObject *visible);
typedef void (*_Enable_Enemy_Seen) (GameObject *obj,bool enable);
typedef void (*_Set_Display_Color) (unsigned char red,unsigned char green, unsigned char blue);
typedef void (*_Display_Text) (int strnum);
typedef void (*_Display_Float) (float num,const char *msg);
typedef void (*_Display_Int) (int num,const char *msg);
typedef void (*_Save_Data) (ScriptSaver &saver,int number,int size,void *data);
typedef void (*_Save_Pointer) (ScriptSaver &saver,int number,void *data);
typedef char (*_Load_Begin) (ScriptLoader &loader,int *subchunkno);
typedef void (*_Load_Data) (ScriptLoader &loader,int size,void *data);
typedef void (*_Load_Pointer) (ScriptLoader &loader,void **data);
typedef void (*_Load_End) (ScriptLoader &loader);
typedef void (*_Begin_Chunk) (ScriptSaver &saver,unsigned int chunktype);
typedef void (*_End_Chunk) (ScriptSaver &saver);
typedef char (*_Open_Chunk) (ScriptLoader &loader,unsigned int *chunktype);
typedef void (*_Close_Chunk) (ScriptLoader &loader);
typedef void (*_Clear_Radar_Markers) ();
typedef void (*_Clear_Radar_Marker) (int marker);
typedef void (*_Add_Radar_Marker) (int marker, const Vector3 & pos,int shape, int color);
typedef void (*_Set_Obj_Radar_Blip_Shape) (GameObject *obj,int shape);
typedef void (*_Set_Obj_Radar_Blip_Color) (GameObject *obj,int color);
typedef void (*_Enable_Radar) (bool enable);
typedef void (*_Clear_Map_Cell) (int x,int y);
typedef void (*_Clear_Map_Cell_By_Pos) (const Vector3 & pos);
typedef void (*_Clear_Map_Cell_By_Pixel_Pos) (int x,int y);
typedef void (*_Clear_Map_Region_By_Pos) (const Vector3 & pos,int reigon);
typedef void (*_Reveal_Map) ();
typedef void (*_Shroud_Map) ();
typedef void (*_Show_Player_Map_Marker) (bool show);
typedef float (*_Get_Safe_Flight_Height) (float x,float y);
typedef void (*_Create_Explosion) (const char *explosion,const Vector3 & pos,GameObject *damager);
typedef void (*_Create_Explosion_At_Bone) (const char *explosion,GameObject *obj,const char *bone,GameObject *damager);
typedef void (*_Enable_HUD) (bool enable);
typedef void (*_Mission_Complete) (bool won);
typedef void (*_Give_Powerup) (GameObject *obj,const char *powerup,bool showonhud);
typedef void (*_Innate_Disable) (GameObject *obj);
typedef void (*_Innate_Enable) (GameObject *obj);
typedef void (*_Innate_Soldier_Enable_Enemy_Seen) (GameObject *obj,bool enable);
typedef void (*_Innate_Soldier_Enable_Gunshot_Heard) (GameObject *obj,bool enable);
typedef void (*_Innate_Soldier_Enable_Footsteps_Heard) (GameObject *obj,bool enable);
typedef void (*_Innate_Soldier_Enable_Bullet_Heard) (GameObject *obj,bool enable);
typedef void (*_Innate_Soldier_Enable_Actions) (GameObject *obj,bool enable);
typedef void (*_Set_Innate_Soldier_Home_Location) (GameObject *obj,const Vector3 & pos, float facing);
typedef void (*_Set_Innate_Aggressiveness) (GameObject *obj,float aggressiveness);
typedef void (*_Set_Innate_Take_Cover_Probability) (GameObject *obj,float probobility);
typedef void (*_Set_Innate_Is_Stationary) (GameObject *obj,bool is_stationary);
typedef void (*_Innate_Force_State_Bullet_Heard) (GameObject *obj,const Vector3 & pos);
typedef void (*_Innate_Force_State_Footsteps_Heard) (GameObject *obj,const Vector3 & pos);
typedef void (*_Innate_Force_State_Gunshots_Heard) (GameObject *obj,const Vector3 & pos);
typedef void (*_Innate_Force_State_Enemy_Seen) (GameObject *obj,GameObject * seen);
typedef void (*_Static_Anim_Phys_Goto_Frame) (int ID,float frame,const char *anim);
typedef void (*_Static_Anim_Phys_Goto_Last_Frame) (int ID,const char *anim);
typedef float (*_Get_Sync_Time) ();
typedef void (*_Add_Objective) (int objectivenum,int type,int objtitleid,int descriptionid,char *soundname,int unknown);
typedef void (*_Remove_Objective) (int objectivenum);
typedef void (*_Set_Objective_Status) (int objectivenum,int status);
typedef void (*_Change_Objective_Type) (int objectivenum,int type);
typedef void (*_Set_Objective_Radar_Blip) (int objectivenum,const Vector3 & pos);
typedef void (*_Set_Objective_Radar_Blip_Object) (int objectivenum,GameObject *obj);
typedef void (*_Set_Objective_HUD_Info) (int objectivenum,float priority,const char *pogfile,int pogtitleid);
typedef void (*_Set_Objective_HUD_Info_Position) (int objectivenum,float priority,const char *pogfile,int pogtitleid,const Vector3 & pos);
typedef void (*_Shake_Camera) (const Vector3 & pos,float radius,float intensity,float time);
typedef void (*_Enable_Spawner) (int ID,bool enable);
typedef void (*_Trigger_Spawner) (int ID);
typedef void (*_Enable_Engine) (GameObject *obj,bool enable);
typedef int (*_Get_Difficulty_Level) ();
typedef void (*_Grant_Key) (GameObject *obj,int keynum,bool grant);
typedef bool (*_Has_Key) (GameObject *obj,int keynum);
typedef void (*_Enable_Hibernation) (GameObject *obj,bool enable);
typedef void (*_Attach_To_Object_Bone) (GameObject *attatch,GameObject *obj,const char *bonename);
typedef int (*_Create_Conversation) (const char *conv,int unk1,float unk2,bool unk3);
typedef void (*_Join_Conversation) (GameObject *obj,int convno,bool unk1,bool unk2,bool unk3);
typedef void (*_Join_Conversation_Facing) (GameObject *obj,int convno,int facing);
typedef void (*_Start_Conversation) (int convno,int unk);
typedef void (*_Monitor_Conversation) (GameObject *obj,int convno);
typedef void (*_Start_Random_Conversation) (GameObject *obj);
typedef void (*_Stop_Conversation) (int convno);
typedef void (*_Stop_All_Conversations) ();
typedef void (*_Lock_Soldier_Facing) (GameObject *obj,GameObject *lock,bool unk);
typedef void (*_Unlock_Soldier_Facing) (GameObject *obj);
typedef void (*_Apply_Damage) (GameObject *obj,float damage,const char *warhead,GameObject *damager);
typedef void (*_Set_Loiters_Allowed) (GameObject *obj,bool enable);
typedef void (*_Set_Is_Visible) (GameObject *obj,bool enable);
typedef void (*_Set_Is_Rendered) (GameObject *obj,bool enable);
typedef float (*_Get_Points) (GameObject *obj);
typedef void (*_Give_Points) (GameObject *obj,float points,bool entire_team);
typedef float (*_Get_Money) (GameObject *obj);
typedef void (*_Give_Money) (GameObject *obj,float money,bool entire_team);
typedef bool (*_Get_Building_Power) (GameObject *obj);
typedef void (*_Set_Building_Power) (GameObject *obj,bool enable);
typedef void (*_Play_Building_Announcement) (GameObject *obj, int announcement);
typedef void (*_Find_Nearest_Building) (GameObject *obj, const char *building);
typedef void (*_Find_Nearest_Building_To_Pos) (const Vector3 & pos, const char *building);
typedef int (*_Team_Members_In_Zone) (GameObject *zone, int team);
typedef void (*_Set_Clouds) (float cover, float gloominess, float transition);
typedef void (*_Set_Lightning) (float intensity, float start_distance, float end_distance, float heading, float distribution, float transition);
typedef void (*_Set_War_Blitz) (float intensity, float start_distance, float end_distance, float heading, float distribution, float transition);
typedef void (*_Set_Wind) (float heading, float speed, float variability, float transition);
typedef void (*_Set_Rain) (float density,float transition, bool unused);
typedef void (*_Set_Snow) (float density,float transition, bool unused);
typedef void (*_Set_Ash) (float density,float transition, bool unused);
typedef void (*_Set_Fog_Enable) (bool enable);
typedef void (*_Set_Fog_Range) (float Start_Distance, float End_Distance, float transition);
typedef void (*_Enable_Stealth) (GameObject *obj,bool enable);
typedef void (*_Cinematic_Sniper_Control) (bool enable,float zoom);
typedef int (*_Text_File_Open) (const char *filename);
typedef bool (*_Text_File_Get_String) (int handle,char *data,int size);
typedef void (*_Text_File_Close) (int handle);
typedef void (*_Enable_Vehicle_Transitions) (GameObject *obj,bool enable);
typedef void (*_Display_GDI_Player_Terminal) ();
typedef void (*_Display_NOD_Player_Terminal) ();
typedef void (*_Display_Mutant_Player_Terminal) ();
typedef bool (*_Reveal_Encyclopedia_Character) (int EncyclopediaID);
typedef bool (*_Reveal_Encyclopedia_Weapon) (int EncyclopediaID);
typedef bool (*_Reveal_Encyclopedia_Vehicle) (int EncyclopediaID);
typedef bool (*_Reveal_Encyclopedia_Building) (int EncyclopediaID);
typedef void (*_Display_Encyclopedia_Event_UI) ();
typedef void (*_Scale_AI_Awareness) (float globalsightrangescale, float unused);
typedef void (*_Enable_Cinematic_Freeze) (GameObject *obj,bool enable);
typedef void (*_Expire_Powerup) (GameObject *obj);
typedef void (*_Set_HUD_Help_Text) (int id,const Vector3 & color);
typedef void (*_Enable_HUD_Pokable_Indicator) (GameObject *obj,bool is_pokeable);
typedef void (*_Enable_Innate_Conversations) (GameObject *obj,bool enable);
typedef void (*_Display_Health_Bar) (GameObject *obj, bool display);
typedef void (*_Enable_Shadow) (GameObject *obj,bool enable);
typedef void (*_Clear_Weapons) (GameObject *obj);
typedef void (*_Set_Num_Tertiary_Objectives) (int num);
typedef void (*_Enable_Letterbox) (bool enable,float unk);
typedef void (*_Set_Screen_Fade_Color) (float red,float green,float blue,float transition);
typedef void (*_Set_Screen_Fade_Opacity) (float opacity,float transition);
//note: "tested" after a script command means that someone has actually used it in a script and we have verified that it does what we think it does and that we know how to use it.
//also "doesnt work in MP" means that it will not work for machines other than the host in standard renegade. Some extra code may be able to get it working however.
struct ScriptCommands {
	unsigned int version1;
	unsigned int version2;
	_Debug_Message Debug_Message; //doesnt work in the public builds of renegade, one can always use your own calls to fopen and fwrite and etc
	_Action_Reset Action_Reset; //tested
	_Action_Goto Action_Goto; //partially tested (command works but there is a lot more testing to figure out all the fields in the ActionParamsStruct to do)
	_Action_Attack Action_Attack; //partially tested (command works but there is a lot more testing to figure out all the fields in the ActionParamsStruct to do)
	_Action_Play_Animation Action_Play_Animation; //partially tested (command works but there is a lot more testing to figure out all the fields in the ActionParamsStruct to do), may not work in MP
	_Action_Enter_Exit Action_Enter_Exit;
	_Action_Face_Location Action_Face_Location; //partially tested (command works but there is a lot more testing to figure out all the fields in the ActionParamsStruct to do)
	_Action_Dock Action_Dock; //partially tested (command works but there is a lot more testing to figure out all the fields in the ActionParamsStruct to do)
	_Action_Follow_Input Action_Follow_Input; //partially tested (command works but there is a lot more testing to figure out all the fields in the ActionParamsStruct to do)
	_Modify_Action Modify_Action; //partially tested (command works but there is a lot more testing to figure out all the fields in the ActionParamsStruct to do)
	_Get_Action_ID Get_Action_ID;
	_Get_Action_Params Get_Action_Params;
	_Is_Performing_Pathfind_Action Is_Performing_Pathfind_Action;
	_Set_Position Set_Position; //tested
	_Get_Position Get_Position; //tested
	_Get_Bone_Position Get_Bone_Position; //tested
	_Get_Facing Get_Facing; //tested
	_Set_Facing Set_Facing; //tested
	_Disable_All_Collisions Disable_All_Collisions; //tested
	_Disable_Physical_Collisions Disable_Physical_Collisions; //tested
	_Enable_Collisions Enable_Collisions; //tested
	_Destroy_Object Destroy_Object; //tested
	_Find_Object Find_Object; //tested
	_Create_Object Create_Object; //tested
	_Create_Object_At_Bone Create_Object_At_Bone; //tested
	_Get_ID Get_ID; //tested
	_Get_Preset_ID Get_Preset_ID; //tested
	_Get_Preset_Name Get_Preset_Name; //tested
	_Attach_Script Attach_Script; //tested
	_Add_To_Dirty_Cull_List Add_To_Dirty_Cull_List; //tested
	_Start_Timer Start_Timer; //tested
	_Trigger_Weapon Trigger_Weapon;
	_Select_Weapon Select_Weapon; //tested
	_Send_Custom_Event Send_Custom_Event; //tested
	_Send_Damaged_Event Send_Damaged_Event;
	_Get_Random Get_Random; //tested
	_Get_Random_Int Get_Random_Int; //tested
	_Find_Random_Simple_Object Find_Random_Simple_Object;
	_Set_Model Set_Model; //tested
	_Set_Animation Set_Animation; //tested, doesnt work in MP
	_Set_Animation_Frame Set_Animation_Frame; //tested, doesnt work in MP
	_Create_Sound Create_Sound; //tested, this one takes a preset, doesnt work in MP
	_Create_2D_Sound Create_2D_Sound; //tested, this one takes a preset, doesnt work in MP
	_Create_2D_WAV_Sound Create_2D_WAV_Sound; //tested, doesnt work in MP
	_Create_3D_WAV_Sound_At_Bone Create_3D_WAV_Sound_At_Bone; //tested, doesnt work in MP
	_Create_3D_Sound_At_Bone Create_3D_Sound_At_Bone; //tested, doesnt work in MP
	_Create_Logical_Sound Create_Logical_Sound; //tested, this one takes a "logical sound", doesnt work in MP
	_Start_Sound Start_Sound; //doesnt work in MP
	_Stop_Sound Stop_Sound; //doesnt work in MP
	_Monitor_Sound Monitor_Sound; //doesnt work in MP
	_Set_Background_Music Set_Background_Music; //tested, doesnt work in MP
	_Fade_Background_Music Fade_Background_Music; //doesnt work in MP
	_Stop_Background_Music Stop_Background_Music; //tested, doesnt work in MP 
	_Get_Health Get_Health; //tested
	_Get_Max_Health Get_Max_Health; //tested
	_Set_Health Set_Health; //tested
	_Get_Shield_Strength Get_Shield_Strength; //tested
	_Get_Max_Shield_Strength Get_Max_Shield_Strength; //tested
	_Set_Shield_Strength Set_Shield_Strength; //tested
	_Set_Shield_Type Set_Shield_Type; //tested
	_Get_Player_Type Get_Player_Type; //tested, doesnt work on Buildings or Script Zones
	_Set_Player_Type Set_Player_Type; //tested, doesnt work on Buildings or Script Zones
	_Get_Distance Get_Distance; //tested
	_Set_Camera_Host Set_Camera_Host; //tested
	_Force_Camera_Look Force_Camera_Look; //tested
	_Get_The_Star Get_The_Star; //tested, not for MP
	_Get_A_Star Get_A_Star; //tested
	_Find_Closest_Soldier Find_Closest_Soldier; //tested
	_Is_A_Star Is_A_Star; //tested
	_Control_Enable Control_Enable;
	_Get_Damage_Bone_Name Get_Damage_Bone_Name; //tested
	_Get_Damage_Bone_Direction Get_Damage_Bone_Direction;
	_Is_Object_Visible Is_Object_Visible;
	_Enable_Enemy_Seen Enable_Enemy_Seen; //tested
	_Set_Display_Color Set_Display_Color; //doesnt work in MP
	_Display_Text Display_Text; //tested, doesnt work in MP
	_Display_Float Display_Float; //tested, doesnt work in MP
	_Display_Int Display_Int; //tested, doesnt work in MP
	_Save_Data Save_Data; //tested, doesnt work in MP
	_Save_Pointer Save_Pointer; //doesnt work in MP
	_Load_Begin Load_Begin; //tested, doesnt work in MP
	_Load_Data Load_Data; //tested, doesnt work in MP
	_Load_Pointer Load_Pointer; //doesnt work in MP
	_Load_End Load_End; //tested, doesnt work in MP
	_Begin_Chunk Begin_Chunk; //tested, doesnt work in MP
	_End_Chunk End_Chunk; //tested, doesnt work in MP
	_Open_Chunk Open_Chunk; //tested, doesnt work in MP
	_Close_Chunk Close_Chunk; //tested, doesnt work in MP
	_Clear_Radar_Markers Clear_Radar_Markers; //doesnt work in MP
	_Clear_Radar_Marker Clear_Radar_Marker; //tested, doesnt work in MP
	_Add_Radar_Marker Add_Radar_Marker; //tested, doesnt work in MP
	_Set_Obj_Radar_Blip_Shape Set_Obj_Radar_Blip_Shape; //tested, doesnt work in MP
	_Set_Obj_Radar_Blip_Color Set_Obj_Radar_Blip_Color; //tested, doesnt work in MP
	_Enable_Radar Enable_Radar; //tested, doesnt work in MP
	_Clear_Map_Cell Clear_Map_Cell; //tested, doesnt work in MP
	_Clear_Map_Cell_By_Pos Clear_Map_Cell_By_Pos; //doesnt work in MP
	_Clear_Map_Cell_By_Pixel_Pos Clear_Map_Cell_By_Pixel_Pos; //doesnt work in MP
	_Clear_Map_Region_By_Pos Clear_Map_Region_By_Pos; //doesnt work in MP
	_Reveal_Map Reveal_Map; //doesnt work in MP
	_Shroud_Map Shroud_Map; //doesnt work in MP
	_Show_Player_Map_Marker Show_Player_Map_Marker; //doesnt work in MP
	_Get_Safe_Flight_Height Get_Safe_Flight_Height; //tested
	_Create_Explosion Create_Explosion; //tested, doesnt work in MP
	_Create_Explosion_At_Bone Create_Explosion_At_Bone; //tested, doesnt work in MP
	_Enable_HUD Enable_HUD; //tested, doesnt work in MP
	_Mission_Complete Mission_Complete; //tested, doesnt work in MP
	_Give_Powerup Give_Powerup; //tested
	_Innate_Disable Innate_Disable; //tested
	_Innate_Enable Innate_Enable; //tested
	_Innate_Soldier_Enable_Enemy_Seen Innate_Soldier_Enable_Enemy_Seen; //tested
	_Innate_Soldier_Enable_Gunshot_Heard Innate_Soldier_Enable_Gunshot_Heard; //tested
	_Innate_Soldier_Enable_Footsteps_Heard Innate_Soldier_Enable_Footsteps_Heard; //tested
	_Innate_Soldier_Enable_Bullet_Heard Innate_Soldier_Enable_Bullet_Heard; //tested
	_Innate_Soldier_Enable_Actions Innate_Soldier_Enable_Actions; //tested
	_Set_Innate_Soldier_Home_Location Set_Innate_Soldier_Home_Location;
	_Set_Innate_Aggressiveness Set_Innate_Aggressiveness;
	_Set_Innate_Take_Cover_Probability Set_Innate_Take_Cover_Probability;
	_Set_Innate_Is_Stationary Set_Innate_Is_Stationary;
	_Innate_Force_State_Bullet_Heard Innate_Force_State_Bullet_Heard;
	_Innate_Force_State_Footsteps_Heard Innate_Force_State_Footsteps_Heard;
	_Innate_Force_State_Gunshots_Heard Innate_Force_State_Gunshots_Heard;
	_Innate_Force_State_Enemy_Seen Innate_Force_State_Enemy_Seen;
	_Static_Anim_Phys_Goto_Frame Static_Anim_Phys_Goto_Frame; //tested, doesnt work in MP
	_Static_Anim_Phys_Goto_Last_Frame Static_Anim_Phys_Goto_Last_Frame; //tested, doesnt work in MP
	_Get_Sync_Time Get_Sync_Time; //tested
	_Add_Objective Add_Objective; //tested, doesnt work in MP
	_Remove_Objective Remove_Objective; //tested, doesnt work in MP
	_Set_Objective_Status Set_Objective_Status; //tested, doesnt work in MP
	_Change_Objective_Type Change_Objective_Type; //tested, doesnt work in MP
	_Set_Objective_Radar_Blip Set_Objective_Radar_Blip; //tested, doesnt work in MP
	_Set_Objective_Radar_Blip_Object Set_Objective_Radar_Blip_Object; //tested, doesnt work in MP
	_Set_Objective_HUD_Info Set_Objective_HUD_Info; //tested, doesnt work in MP
	_Set_Objective_HUD_Info_Position Set_Objective_HUD_Info_Position; //tested, doesnt work in MP
	_Shake_Camera Shake_Camera; //tested
	_Enable_Spawner Enable_Spawner; //tested
	_Trigger_Spawner Trigger_Spawner;
	_Enable_Engine Enable_Engine; //tested but still no clue what it does, relates to vechicles tho
	_Get_Difficulty_Level Get_Difficulty_Level; //tested
	_Grant_Key Grant_Key; //tested
	_Has_Key Has_Key; //tested
	_Enable_Hibernation Enable_Hibernation; //tested
	_Attach_To_Object_Bone Attach_To_Object_Bone; //tested
	_Create_Conversation Create_Conversation; // doesnt work in MP
	_Join_Conversation Join_Conversation; // doesnt work in MP
	_Join_Conversation_Facing Join_Conversation_Facing; // doesnt work in MP
	_Start_Conversation Start_Conversation; // doesnt work in MP
	_Monitor_Conversation Monitor_Conversation; // doesnt work in MP
	_Start_Random_Conversation Start_Random_Conversation; // doesnt work in MP
	_Stop_Conversation Stop_Conversation; // doesnt work in MP
	_Stop_All_Conversations Stop_All_Conversations; // doesnt work in MP
	_Lock_Soldier_Facing Lock_Soldier_Facing; //tested
	_Unlock_Soldier_Facing Unlock_Soldier_Facing; //tested
	_Apply_Damage Apply_Damage; //tested, the "damager" is the object that should be treated as doing the damage (for the purposes of the Damaged event and probobly also points)
	_Set_Loiters_Allowed Set_Loiters_Allowed; //tested
	_Set_Is_Visible Set_Is_Visible; //tested (only affects the Is_Object_Visible command and also I think Enemy_Seen logic)
	_Set_Is_Rendered Set_Is_Rendered; //tested
	_Get_Points Get_Points; //tested
	_Give_Points Give_Points; //tested, negative numbers work
	_Get_Money Get_Money; //tested
	_Give_Money Give_Money; //tested, negative numbers work
	_Get_Building_Power Get_Building_Power; //tested
	_Set_Building_Power Set_Building_Power; //tested (only the base defences seem to actually power down)
	_Play_Building_Announcement Play_Building_Announcement;
	_Find_Nearest_Building Find_Nearest_Building;
	_Find_Nearest_Building_To_Pos Find_Nearest_Building_To_Pos;
	_Team_Members_In_Zone Team_Members_In_Zone;
	_Set_Clouds Set_Clouds; //tested
	_Set_Lightning Set_Lightning; //tested
	_Set_War_Blitz Set_War_Blitz;
	_Set_Wind Set_Wind; //tested
	_Set_Rain Set_Rain; //tested
	_Set_Snow Set_Snow; //tested
	_Set_Ash Set_Ash; //tested
	_Set_Fog_Enable Set_Fog_Enable; //tested, doesnt work in MP
	_Set_Fog_Range Set_Fog_Range; //tested, doesnt work in MP
	_Enable_Stealth Enable_Stealth; //tested, doesnt work in MP
	_Cinematic_Sniper_Control Cinematic_Sniper_Control; //tested (the sniper effect probobly only happens if you call other commands first or something, more work needed), doesnt work in MP
	_Text_File_Open Text_File_Open;
	_Text_File_Get_String Text_File_Get_String;
	_Text_File_Close Text_File_Close;
	_Enable_Vehicle_Transitions Enable_Vehicle_Transitions; //tested
	_Display_GDI_Player_Terminal Display_GDI_Player_Terminal; //tested, doesnt work in MP
	_Display_NOD_Player_Terminal Display_NOD_Player_Terminal; //tested, doesnt work in MP
	_Display_Mutant_Player_Terminal Display_Mutant_Player_Terminal; //crashes renegade if you use it 
	_Reveal_Encyclopedia_Character Reveal_Encyclopedia_Character; //tested, doesnt work in MP
	_Reveal_Encyclopedia_Weapon Reveal_Encyclopedia_Weapon; //tested, doesnt work in MP
	_Reveal_Encyclopedia_Vehicle Reveal_Encyclopedia_Vehicle; //tested, doesnt work in MP
	_Reveal_Encyclopedia_Building Reveal_Encyclopedia_Building; //tested, doesnt work in MP
	_Display_Encyclopedia_Event_UI Display_Encyclopedia_Event_UI; //tested, doesnt work in MP
	_Scale_AI_Awareness Scale_AI_Awareness;
	_Enable_Cinematic_Freeze Enable_Cinematic_Freeze;
	_Expire_Powerup Expire_Powerup; //tested
	_Set_HUD_Help_Text Set_HUD_Help_Text; //tested, doesnt work in MP
	_Enable_HUD_Pokable_Indicator Enable_HUD_Pokable_Indicator; //tested
	_Enable_Innate_Conversations Enable_Innate_Conversations;
	_Display_Health_Bar Display_Health_Bar; //tested
	_Enable_Shadow Enable_Shadow; //tested
	_Clear_Weapons Clear_Weapons; //tested
	_Set_Num_Tertiary_Objectives Set_Num_Tertiary_Objectives; //tested, doesnt work in MP
	_Enable_Letterbox Enable_Letterbox; //tested, doesnt work in MP
	_Set_Screen_Fade_Color Set_Screen_Fade_Color; //tested, doesnt work in MP
	_Set_Screen_Fade_Opacity Set_Screen_Fade_Opacity; //tested, doesnt work in MP
};
typedef ScriptCommands *ScriptCommandsClass;
extern ScriptCommandsClass Commands;
